/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.item;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.genetic.AgriGenomeProviderItem;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.common.block.entity.SeedAnalyzerBlockEntity;
import com.agricraft.agricraft.common.registry.ModBlocks;
import com.agricraft.agricraft.common.registry.ModItems;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class AgriSeedItem
extends BlockItem
implements AgriGenomeProviderItem {
    public AgriSeedItem(Item.Properties properties) {
        super((Block)ModBlocks.CROP.get(), properties);
    }

    public static ItemStack toStack(AgriPlant plant) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SEED.get(), 1);
        AgriGenome genome = new AgriGenome(plant);
        CompoundTag tag = new CompoundTag();
        genome.writeToNBT(tag);
        stack.m_41751_(tag);
        return stack;
    }

    public static ItemStack toStack(AgriGenome genome) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SEED.get(), 1);
        CompoundTag tag = new CompoundTag();
        genome.writeToNBT(tag);
        stack.m_41751_(tag);
        return stack;
    }

    public static String getSpecies(ItemStack stack) {
        if (stack.m_41720_() != ModItems.SEED.get()) {
            return "agricraft:unknown";
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return "agricraft:unknown";
        }
        AgriGenome genome = AgriGenome.fromNBT(tag);
        if (genome == null) {
            return "agricraft:unknown";
        }
        return genome.getSpeciesGene().getDominant().trait();
    }

    public Component m_7626_(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return Component.m_237115_((String)"seed.agricraft.agricraft.unknown");
        }
        AgriGenome genome = AgriGenome.fromNBT(stack.m_41783_());
        if (genome == null) {
            return Component.m_237115_((String)"seed.agricraft.agricraft.unknown");
        }
        return LangUtils.seedName(genome.getSpeciesGene().getDominant().trait());
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        InteractionResult result = super.m_40576_(context);
        Level level = context.m_43725_();
        if (result.m_19077_() && !level.f_46443_) {
            AgriApi.getCrop((BlockGetter)level, context.m_8083_()).ifPresent(crop -> {
                CompoundTag tag = context.m_43722_().m_41783_();
                if (tag != null) {
                    crop.plantGenome(AgriGenome.fromNBT(tag));
                }
            });
        }
        return result;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = context.m_43722_();
        Optional<AgriCrop> optionalAgriCrop = AgriApi.getCrop((BlockGetter)level, context.m_8083_());
        if (optionalAgriCrop.isPresent()) {
            AgriCrop crop = optionalAgriCrop.get();
            if (crop.hasPlant() || crop.isCrossCropSticks()) {
                return InteractionResult.PASS;
            }
            this.plantSeed(context.m_43723_(), crop, heldItem);
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(context.m_8083_());
        if (blockEntity instanceof SeedAnalyzerBlockEntity) {
            SeedAnalyzerBlockEntity seedAnalyzer = (SeedAnalyzerBlockEntity)blockEntity;
            if (seedAnalyzer.hasSeed()) {
                return InteractionResult.PASS;
            }
            ItemStack remaining = seedAnalyzer.insertSeed(heldItem);
            heldItem.m_41764_(remaining.m_41613_());
            return InteractionResult.CONSUME;
        }
        return AgriApi.getSoil(level, context.m_8083_()).map(soil -> AgriApi.getCrop((BlockGetter)level, context.m_8083_().m_7494_()).map(crop -> {
            if (crop.hasPlant() || crop.isCrossCropSticks()) {
                return InteractionResult.PASS;
            }
            this.plantSeed(context.m_43723_(), (AgriCrop)crop, heldItem);
            return InteractionResult.CONSUME;
        }).orElse(InteractionResult.PASS)).orElse(super.m_6225_(context));
    }

    private void plantSeed(Player player, AgriCrop crop, ItemStack seed) {
        crop.plantGenome(AgriGenome.fromNBT(seed.m_41783_()), (LivingEntity)player);
        if (player != null && !player.m_7500_()) {
            seed.m_41774_(1);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        AgriGenome genome;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (genome = AgriGenome.fromNBT(tag)) != null) {
            genome.appendHoverText(tooltipComponents, isAdvanced);
        }
    }
}

